//
//  OPDatabase+Private.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2015-04-13.
//
//

#import <OnePasswordDatabase/OPDatabase.h>

@class SQLite;

// Should only be accessed by subclasses.

@interface OPDatabase ()

@property (nonatomic, strong) NSOperationQueue *queue;
@property (nonatomic, strong) SQLite *sqlite;

@property (nonatomic, strong) NSMutableArray *itemsAdded;
@property (nonatomic, strong) NSMutableArray *itemsUpdated;
@property (nonatomic, strong) NSMutableArray *itemsRemoved;

@property (nonatomic, strong) NSMutableArray *itemUsageChanged;

@property (nonatomic, strong) NSMutableArray *itemTagsAdded;
@property (nonatomic, strong) NSMutableArray *itemTagsRemoved;

@property (nonatomic, strong) NSMutableArray *favoritesUpdated;

@property (nonatomic, strong) NSMutableArray *foldersAdded;
@property (nonatomic, strong) NSMutableArray *foldersUpdated;

@property (nonatomic, strong) NSMutableArray *categoriesAdded;
@property (nonatomic, strong) NSMutableArray *categoriesUpdated;

@property (nonatomic, strong) NSMutableSet *affectedProfileUUIDs; // Converted to NSArray before throwing over XPC

@property (nonatomic, strong) NSMutableDictionary *itemCache; // Do not use NSCache, it is much slower and we don't need thread-safety here

@property (nonatomic, strong) NSMutableDictionary *attachedDatabases;

@end

@interface OPDatabase (Private)

- (void)beginTransaction;
- (void)commitTransaction;
- (void)rollbackTransaction;

- (BOOL)_pragmasWithError:(NSError **)error;
- (BOOL)_enableSQLiteForeignKeys:(NSError **)error;
- (void)postNotificationName:(NSString *)notificationName object:(id)object userInfo:(NSDictionary *)userInfo;

- (void)databaseOperationWillStart;
- (void)databaseOperationDidFinish;

- (void)_performSyncTransaction:(void (^)(OPDatabase *db, BOOL *rollback))transaction withPriority:(NSOperationQueuePriority)priority;
- (OPDatabaseOperation *)_performAsyncTransaction:(void (^)(OPDatabase *db, BOOL *rollback))transaction withPriority:(NSOperationQueuePriority)priority completion:(void (^)(BOOL success))completion;
- (void)_performExclusiveOperationWithoutTransaction:(void (^)(OPDatabase *db))nontransaction;

- (void)_reattachDatabases;

@end
